#include "starfield.h"

#include <stdlib.h>
#include <malloc.h>

StarField::StarField(Object *parent, int num_stars) : Object(parent) {
	this->num_stars = num_stars;

	star_pos = new float[num_stars][6];

	for(int i = 0; i < num_stars; i++) {
		star_pos[i][2] = (rand() % 80) * 0.01f + 0.01;
		star_pos[i][3] = 1.0f / star_pos[i][2];
	}
}

void StarField::setPositions(float windoww, float windowh) {
	for(int i = 0; i < num_stars; i++) {	
		star_pos[i][4] = windoww * star_pos[i][3];
		star_pos[i][5] = windoww * star_pos[i][3];
		star_pos[i][0] = rand() % (int)(star_pos[i][4]);
		star_pos[i][1] = rand() % (int)(star_pos[i][5]);
	}
}

void StarField::draw(float offx, float offy, float windoww, float windowh) {
	static float ow = -1, oh = -1;
	if(windoww != ow || windowh != oh) {
		setPositions(windoww, windowh);
		ow = windoww;
		oh = windowh;
	}

	glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
	glPointSize(3.0f);
	
	float ox, oy;
	float cx, cy;

	cx = offx + windoww * 0.5f;
	cy = offy + windowh * 0.5f;

	glBegin(GL_POINTS);

		for(int i = 0; i < num_stars; i++) {
			ox = fmod(star_pos[i][0] + offx, star_pos[i][4]);
			ox = - star_pos[i][2] * (ox - star_pos[i][4] * 0.5f) + cx;

			oy = fmod(star_pos[i][1] + offy, star_pos[i][5]);
			oy = - star_pos[i][2] * (oy - star_pos[i][5] * 0.5f) + cy;

			glColor3f(star_pos[i][2] + 0.1f, star_pos[i][2] + 0.1f, star_pos[i][2] + 0.1f);
			glVertex3f(ox, oy, 0.0f);
		}

	glEnd();
}